//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: operate SST25V using SIO
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6822_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 
#include "sst25v_spi.h"

/*    					 8-lead SOIC                                      
       				   ____________ 
					  |            |
		(SS)P77-  CE#-|	1		 8 |-VDD  (3.3v)
					  |            |
		(SI)P74-   SO-|            |-HOLD# -H
					  |   Top View |
			  H-  WP#-|            |-SCK   -P76(SCLK)
					  |            |
				  VSS-|____________|-SI    -P75(SO)
	                      SST25V                                       MQ6822
						 (slave)                                      (master)
	  
 
 	

 
 */
 unsigned char Get[10];
unsigned char IDD[3];
void main()
{
	
	unsigned char Send[10];
	Send[0]=0x1;
	Send[1]=0x2;
	Send[2]=0x3;
	Send[3]=0x4;
	Send[4]=0x5;
	Send[5]=0x6;
	Send[6]=0x7;
	Send[7]=0x8;
	Send[8]=0x9;
	Send[9]=0xA;
	
	
	
//===============================================
// 	P74-SI P75-SO P76-SCLK P77-SS enable SIO(SPI) 
//===============================================
	SPI_init();
	
//===============================================
// 	Initial SST25V status
//===============================================	
	SST25V_Init();

//===============================================
// 	Read SST25V JEDEC Code 
//===============================================	
	SST25V_ReadJEDECID(IDD);

//===============================================
// 	void  SST25V_EraseBlock32KB(unsigned long int addr)
//  Erase Block:0x0~0x7fff,0x8000~0xffff and so on
//===============================================	
	SST25V_EraseBlock32KB(0x0);

//===============================================
//	void SST25V_ReadInc(unsigned long int addr, unsigned char* dat_ptr, unsigned int count)
//addr:Read Start Address
//dat_ptr:Read Buffer
//count:Read Length
//=============================================== 
 	SST25V_ReadInc(0x0, Get, 1);
	SST25V_ReadInc(0x8000, Get, 1);
	SST25V_ReadInc(0x7fff, Get, 1);	
	
//===============================================
//	void SST25V_WriteByte(unsigned long int addr, unsigned char dat)
//	addr:Program Address
//  dat :Program Data
//===============================================
 	SST25V_WriteByte(0x0,0xAA);
	SST25V_WriteByte(0x8000,0xAA);
	SST25V_WriteByte(0x7fff,0xAA);
 



	//read
 	SST25V_ReadInc(0x0, Get, 1);
	SST25V_ReadInc(0x8000, Get, 1);
	SST25V_ReadInc(0x7fff, Get, 1);
	
	SST25V_EraseBlock32KB(0x0);
	
 	SST25V_ReadInc(0x0, Get, 1);
	SST25V_ReadInc(0x8000, Get, 1);
	SST25V_ReadInc(0x7fff, Get, 1);	
	

//============================================
//	void  SST25V_WriteInc(unsigned long int addr, unsigned char* dat_ptr, unsigned int count)
//	addr:Program Start Address
//  dat_ptr:Write Buffer
//  count: Program Length
//=============================================	
	SST25V_WriteInc(0x2, Send, 10);
	
	
	SST25V_ReadInc(0x2, Get, 10);
	
	while(1){WDCDR.byte = 0x4e;}
}
